//
//  ShortenURL.swift
//  Integration
//
//  Created by NurWork on 23/11/15.
//  Copyright © 2015 RWTH Aachen Univesity. All rights reserved.
//https://github.com/AFNetworking/AFNetworking/wiki/Getting-Started-with-AFNetworking

import Foundation
import UIKit


let UIActivityShortenURL = "Shorten URL"

class ShortenURL: UIActivity {
   
    var shortURL:String = ""
    let apiKey = "AIzaSyA8flnQfXUlubuUoF5FAXvUGdQ_RX9Ze6U"


    override func activityType() -> String? {
        return UIActivityShortenURL
    }
    
    // activity title in the popover
    override func activityTitle() -> String? {
        
        return "Shorten URL"
    }
    
    // activity icon size 60 by 60 points
    override func activityImage() -> UIImage? {

        return UIImage(named: "shortenURLIcon.png")!
    }
    
    // Action or Share (default is Action)
    override class func activityCategory() -> UIActivityCategory {
        return .Action
    }
    
    // confirm the action can be performed
    override func canPerformWithActivityItems(activityItems: [AnyObject]) -> Bool {
        for item in activityItems {
            if let _ = NSURL(string:item as! String){ //check if url is valid
                return true
            }
        }
        return false
    }
    
    // prepare for the activity
    override func prepareWithActivityItems(activityItems: [AnyObject]) {
        
        for item in activityItems
            {
                let manager = AFHTTPRequestOperationManager()
                manager.requestSerializer = AFJSONRequestSerializer() as AFJSONRequestSerializer
                let params = [
                    "longUrl": item
                ]
                manager.POST("https://www.googleapis.com/urlshortener/v1/url?key=\(apiKey)", parameters: params, success: {
                    (operation: AFHTTPRequestOperation!,responseObject: AnyObject!) in
                    if let responseObject = responseObject as? NSDictionary {
                        self.shortURL = (responseObject["id"] as? String)!
                    }
                    },
                    failure: { (operation: AFHTTPRequestOperation?,error: NSError!) in
                        print("Error while requesting shortened: " + error.localizedDescription)
                })

                return //only one item is expected
            }
    }
    
    // perform the activity
    override func performActivity() {
        
        let pasteboard = UIPasteboard.generalPasteboard()
        pasteboard.string = self.shortURL
        
    }
}